import numpy as np
from itertools import product

from QNN_model import train_model


def get_data(sample_point=10):
    x1 = np.linspace(-np.pi, np.pi, sample_point)
    x2 = np.linspace(-np.pi, np.pi, sample_point)

    train_X = np.array(list(product(x1,x2)))
    train_y = (train_X[:,0]**2+train_X[:,1]-1.5*np.pi)**2 + (train_X[:,0]+train_X[:,1]**2-np.pi)**2

    min_y, max_y = np.min(train_y), np.max(train_y)
    a, b = 2/(max_y-min_y), 1-2*max_y/(max_y-min_y)

    train_y = train_y * a + b  #[-1,1]

    return train_X, train_y


if __name__ == '__main__':
    import argparse 

    parser = argparse.ArgumentParser()
    parser.add_argument('-q','--qubit', type=int, default=1)
    parser.add_argument('-l','--layer', type=int, default=10)
    parser.add_argument('-d','--depth', type=int, default=1)
    args = parser.parse_args()

    num_qubit = args.qubit
    layer = args.layer
    depth = args.depth

    print("----------------------qubit :%s ------ layer: %s ------ depth: %s --------------------"%(num_qubit, layer, depth))
 
    train_X, train_y = get_data(sample_point=20)

    print(train_X.shape)
    print(train_y.shape)

    
seed=101
train_loss, predict_y = train_model(train_X, train_y, seed=seed, N=num_qubit, LAYER=layer, DEPTH=depth, EPOCH=10, BATCH_SIZE=40, LR=0.1)
np.save('limitation/data/train_loss_%s_%s_%s_%s.npy'%(num_qubit, layer, depth, seed), train_loss)
np.save('limitation/data/predict_y_%s_%s_%s_%s.npy'%(num_qubit, layer, depth, seed), predict_y)







